#ifndef _DD_SPI_H        /*prevent duplicated includes*/
#define _DD_SPI_H

/******************************************************************************/
/* Include Files                                                              */
/******************************************************************************/

#include "MC9S08GW64.h"
#include "spi_config.h"       //contains various SPI configurations

  typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char LSBFE     :1;        /*LSB first */
    unsigned char SSOE     :1;        /*Slave Select Output Enable*/
    unsigned char CPHA     :1;        /*Clock Phase*/
    unsigned char CPOL     :1;        /*Clock Polarity*/
    unsigned char MSTR     :1;       /*Master/Slave Mode Select*/
    unsigned char SPTIE    :1;       /*SPI Transmit Enable*/
    unsigned char SPE      :1;       /*SPI System Enable*/
    unsigned char SPIE     :1;       /*SPI Interrupt Enable*/
   }Bits;
  }SPI_SPIC1RegType;
  
  typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char SPCO        :1;        /*SPI Pin control 0 */
    unsigned char SPISWAI     :1;        /*SPI stop in wait mode*/
    unsigned char             :1;        /*Unimplemented*/
    unsigned char BIDIROE     :1;        /*Bidirectional Mode Output Enable*/
    unsigned char MODFEN      :1;        /*Master Mode Fault Function Enable*/
    unsigned char             :3;        /*Unimplemented*/
   }Bits;
  }SPI_SPIC2RegType;
  
 typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char SPR0         :1;        /*SPI Baud Rate Divisor*/
    unsigned char SPR1         :1;        /*SPI Baud Rate Divisor*/
    unsigned char SPR2         :1;        /*SPI Baud Rate Divisor*/
    unsigned char SPR3         :1;        /*Unimplemented*/
    unsigned char SPPR0        :1;        /*SPI Baud Rate Prescaler*/
    unsigned char SPPR1        :1;        /*SPI Baud Rate Prescaler*/
    unsigned char SPPR2        :1;        /*SPI Baud Rate Prescaler Divisor*/
    unsigned char              :1;        /*Unimplemented*/
   }Bits;
  }SPI_SPIBRRegType;
 
 typedef union 
  {
   unsigned char Byte;
   struct 
   {
    unsigned char               :4;        /*Unimplemented*/
    unsigned char MODF          :1;        /*Master Mode Fault Flag*/
    unsigned char SPTEF         :1;        /*SPI Transmit Buffer Empty*/
    unsigned char               :1;        /*Unimplemented*/
    unsigned char SPRF          :1;        /*SPI Read Buffer Full Flag*/
   }Bits;
  }SPI_SPISRegType;
 
   
  typedef struct
  {
   SPI_SPIC1RegType SPIC1;   /*SPI Control Register 1*/
   SPI_SPIC2RegType SPIC2;   /*SPI Control Register 2*/
   SPI_SPIBRRegType SPIBR;   /*SPI Baur Rate Register*/
   SPI_SPISRegType  SPIS;    /*SPI Status Register*/
   unsigned char    RESERVED;   /*Reserved */
   unsigned char    SPID;    /*SPI Data Register*/
  }SPI;
  
 #define SPI_0 0x0048
 #define SPI_1 0x0050
 #define SPI_2 0x0058
 
 //PIN MUX
 #define SPI2_PortA 0b001
 #define SPI2_PortD 0b010
 #define SPI1_PortC 0b001
 #define SPI1_PortG 0b001
 #define SPI0_PortB 0b010
 

 #define SPI_Index0 0           //selects SPI0
 #define SPI_Index1 1           //selects SPI1
 #define SPI_Index2 2           //selects SPI2
 
 #define SPI0_RX   0
 #define SPI1_RX   1
 #define SPI2_RX   2
 
 #define SPI0_TX   3
 #define SPI1_TX   4
 #define SPI2_TX   5
 
 
 
 #define SPI_SLAVE_MODE  0      //SPI as slave
 #define SPI_MASTER_MODE 1      //SPI as master
 
 #define SPI_SS_PIN_GPIO       0    //SS pin as GPIO in master mode
 #define SPI_SS_PIN_MODE_FAULT 1    //SS pin as mode fault pin in master mode
 #define SPI_SS_PIN_SS_OUTPUT  2    //SS pin as automatic SS output in master mode
 
 #define SPI_CLOCK_POL_0   0        //clock polarity 0
 #define SPI_CLOCK_POL_1   1        //clock polarity 1
 
 #define SPI_CLOCK_PHASE_0 0        //clock phase 0
 #define SPI_CLOCK_PHASE_1 1        //clock phase 1
 
 #define SPI_INTERRUPT_ENABLE  1     //to enable the interrupts
 #define SPI_INTERRUPT_DISABLE 0     //to disable the interrupts

 
/*Functions*/
void SPI_Init(unsigned char ,unsigned char ,unsigned char,
              unsigned char ,unsigned char,void (*p)(unsigned char, unsigned char)); 
void Send_Data(unsigned char,unsigned char,unsigned char );
unsigned char Wait_For_Data(unsigned char ,unsigned char); 
void SPI_Write_Char(unsigned char , unsigned char ,unsigned char);
unsigned char SPI_Read_Char(unsigned char,unsigned char); 
 

 
  
#endif  